/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_routing.h"
#include "lx_route_file.h"

lx_t lx [2];

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <original map file> <current map file>\n", s);
  exit (0);
}

static int read_map (char*s, lx_t*lx, lx_map_t*m)
{
  FILE*fp;
  lx_node_t*first;
  
  if (!(fp = fopen (s, "r")))
  {
    fprintf (stderr, "couldn't open %s\n", s);
    return 0;
  }
  
  if (!lx_map_file_read (fp, m, &first))
  {
    fprintf (stderr, "lx_map_file_read () failed on %s\n", s);
    return 0;
  }
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);
  return 1;
}

int main (int argc, char*argv [])
{
  int i;
  int c1, c2;
  
  lx_node_t*n;  

  mi_verbose_flag = 0;
  
  if (argc < 3)
    usage (argv [0]);
  
  for (i = 0; i < 2; i++)
  {
    lx_init (&lx [i]);
    if (!read_map (argv [i + 1], &lx [i], &lx [i].maps [0]))
      usage (argv [0]);
  }
  
  for (n = lx [0].maps [0].hosts.head; n; n = mi_index2node (n->next))
  { 
    if (!lx_seen (&lx [1].maps [0], lx_host_c (n)->mac_address))
    {
      printf ("missing " lx_mac_format "\n", lx_mac_args (lx_host_c (n)->mac_address));
    }
  }

  c1 = c2 = 0;
  
  for (n = lx [0].maps [0].xbars.head; n; n = mi_index2node (n->next))
    c1 += lx_get_xbar_count (n);
  
  for (n = lx [1].maps [0].xbars.head; n; n = mi_index2node (n->next))
    c2 += lx_get_xbar_count (n);
  
  printf ("xbar-xbar link counts: %d vs %d\n", c1, c2);

  return 1;
}
